#This file cannot be executed directly, it's included by make_template.sh
#This module manage the SNMP MIB-2 Interfaces (1.3.6.1.2.1.2)
#and ifMib (1.3.6.1.2.1.31) MIB

if  echo "$oid" | grep -E "$ifInterfaces|$ifMib" > /dev/null 2>&1  
then
	ifNumber=$( GetValues "$( GetItems ".1.3.6.1.2.1.2.1.0" "$snmpItems" )" )

	if [ $ifNumber -gt 0 ]
	then
		#Specific module variable definitions
		ifIndex=( $( GetValues "$( GetItems ".1.3.6.1.2.1.2.2.1.1\..*=" "$snmpItems" )" ) )
		ifDescription=( $( GetValues "$( GetItems ".1.3.6.1.2.1.2.2.1.2\..*=" "$snmpItems" )" ) )
		echo ${ifIndex[*]}

		printf "There are $ifNumber interface/s in $ip\nWhich of them dou you want to use:\n\n"

			
		i=0
		for description in ${ifDescription[*]}
		do
			echo "$i-$description"

			if [ "$( ApplyFilters "$description" )" != "" ]
			then
				if [ -z "$filterInterfaces" ]
				then
					filterInterfaces=$i
				else
					filterInterfaces=$filterInterfaces,$i
				fi
			fi
			(( i++ ))
		done
		echo "q-Go back"
		echo -n "Currently selected ($filterInterfaces) just press enter if its ok or make your choice:" 
		read interfaces

		if [ -z "$interfaces" ]
		then
			interfaces=$filterInterfaces
		fi

		#Exit if user select "q"
		if [ "$interfaces" == "q" ]
		then
			clear
			return 3
		fi

		interfaces=( $( echo $interfaces | sed -r 's/,/\ /g' ) )

		itemMibs=( $( GetItems "${ifIndex[0]} ="  "$snmpItems" | sed -r 's/(.*) =.*/\1/' | xargs snmptranslate | sed -r 's/([^\.]+)\.[0-9].*/\1/' | sort | uniq ) )
		
		i=0
		printf "Which items do you want to get for each interface?\n\n"
		for item in ${itemMibs[*]}
		do
			echo "$i-$item"
			(( i++ ))
		done
		echo "q-Go back"
		echo -n "Make your choice (comma separated list): "
		read items

		#Exit if q
		if [ "$items" == "q" ]
		then
			clear
			return 3
		fi

		items=( $( echo $items | sed -r 's/,/\n/g' | sort | uniq ) )
		
		for item in ${items[*]}
		do
			oid=$( snmptranslate -Ofn ${itemMibs[$item]} )
			for interface in ${interfaces[*]}
			do
				fulloid="$oid.${ifIndex[$interface]}"
				AddToOidTemplate "$fulloid"
			done
		done

		managed="true"
	fi
fi
