#!/bin/bash

#This script update the list of private enterprise numbers assigned by IANA to corporations

if wget http://www.iana.org/assignments/enterprise-numbers 
then
	ids=( $(cat enterprise-numbers | sed -r "s/^([0-9]+)/1.3.6.1.4.1.\1/" | grep -E "^[0-9]") )
	names=( $(cat enterprise-numbers | grep -E '^\ \ [^\ ]' |  sed -r 's/^\ \ (.*)/\1/' | sed -r 's/\ /_/g') )
	echo -n "" > pen-oids.txt
	for (( i=1; i<${#ids[*]};i+=1 ))
	do
		echo ${ids[$i]}:${names[$i]} >> pen-oids.txt
	done
	sed -ir 's/_/\ /g' pen-oids.txt
	rm enterprise-numbers > /dev/null 2&>1
else
	echo "Impossible to download http://www.iana.org/assignments/enterprise-numbers, its internet connection out there?"
fi
