#This file cannot be executed directly, it's included by make_template.sh
#This module manage the creation of templates for zabbix


##################### Contants
SNMPV1=1
SNMPV2=4
SNMPV3=6
INTEGER=3
FLOAT=0
CHARACTER=1
TEXT=4

##################### Variables
itemDelay=60
historyDays=30
trends=365
snmpPort=161
defColors=( '00FF00' '0000FF' 'FF0000' )

function GetKey
{
	#Return the key for each item in the template
	#@Recives
	#  @$1: The oid of te item to build the key

	local key=$( snmptranslate "$1" | sed -r 's/.*::([^\.]+).*/\1/' )
	local index=$( GetIndex "$1" )

	if [ $index -gt 0 ]
	then
		key=$key.$index
	fi

	echo $key
}

function GetIndex
{
	echo $1 | sed -r 's/.*\.([0-9]+)$/\1/'
}

function AddItem
{
	oid="$1"
	itemType="$2"

	dataType=""
	units=""
	zabbyxDelta=""

	if echo $itemType | grep -Ei 'integer|Counter|gauge|unsigned' > /dev/null 2>&1
	then
		valueType=$FLOAT
		dataType="0"
		zabbyxDelta=2
	elif echo $itemType | grep -Ei 'TimeTicks' > /dev/null 2>&1
	then
		valueType=$INTEGER
		dataType="0"
		zabbyxDelta=0
		if [ "$oid" == ".1.3.6.1.2.1.1.3.0" ]
		then
			units="uptime"
		else
			units="unixtime"
		fi
	elif echo $itemType | grep -Ei 'string|octet|object identifier|ipaddress|networkaddress|opaque|bits' > /dev/null 2>&1
	then
		valueType=$TEXT
	elif echo $itemType | grep -Ei 'SEQUENCE' > /dev/null 2>&1
	then
		return 2
	else
		return 1
	fi

	items="$items
				<item type=\"$zabbixType\" key=\"$( GetKey "$oid" )\" value_type=\"$valueType\">
					<description>$( GetKey "$oid" )</description>
					<delay>$itemDelay</delay>
					<history>$historyDays</history>
					<trends>$trends</trends>
					<status>0</status>
					<data_type>$dataType</data_type>
					<units>$units</units>
					<multiplier>0</multiplier>
					<delta>$zabbyxDelta</delta>
					<formula>1</formula>
					<lastlogsize>0</lastlogsize>
					<logtimefmt></logtimefmt>
					<delay_flex></delay_flex>
					<snmp_community>$community</snmp_community>
					<snmp_oid>$oid</snmp_oid>
					<snmp_port>$snmpPort</snmp_port>
					<snmpv3_securityname>$secName</snmpv3_securityname>
					<snmpv3_securitylevel>$secLevel</snmpv3_securitylevel>
					<snmpv3_authpassphrase>$authPassPhrase</snmpv3_authpassphrase>
					<snmpv3_privpassphrase>$privPassPhrase</snmpv3_privpassphrase>
					<applications/>
				</item>"
}

function AddGraph
{
	aux="
				<graph name=\"$graphname\" width=\"900\" height=\"200\">
					<ymin_type>0</ymin_type>
					<ymax_type>0</ymax_type>
					<ymin_item_key></ymin_item_key>
					<ymax_item_key></ymax_item_key>
					<show_work_period>1</show_work_period>
					<show_triggers>1</show_triggers>
					<graphtype>0</graphtype>
					<yaxismin>0.0000</yaxismin>
					<yaxismax>100.0000</yaxismax>
					<show_legend>0</show_legend>
					<show_3d>0</show_3d>
					<percent_left>0.0000</percent_left>
					<percent_right>0.0000</percent_right>
					<graph_elements>"
					local z=0
					for (( z=0; $z<${#drawTypes[*]}; z++ ))
					do
					
	aux="$aux
						<graph_element item=\"$( echo $templateName | sed -r 's/([^\.]+).*/\1/' ):${keys[$z]}\">
							<drawtype>${drawTypes[$z]}</drawtype>
							<sortorder>${sortOrders[$z]}</sortorder>
							<color>${colors[$z]}</color>
							<yaxisside>${yAxysSides[$z]}</yaxisside>
							<calc_fnc>${calcFunctions[$z]}</calc_fnc>
							<type>${elementTypes[$z]}</type>
							<periods_cnt>${periodsCounter[$z]}</periods_cnt>
						</graph_element>"
					done
	graphs="$graphs $aux
					</graph_elements>
				</graph>"
}

function run
{
	if [ -f "$oidInputFile" ]
	then
		snmpVersion=$( echo $options | sed -r 's/.*-v\s*([^ ]+).*/\1/' )
		community=$( echo $options | sed -r 's/.*-c\s*([^ ]+).*/\1/' )
		items=""
		graphs=""

		if [ "$secLevel" != "" ]
		then
			if echo $secLevel | grep -i "NoAuthPriv"
			then
				secLevel=0
			elif echo $secLevel | grep -i "AuthNoPriv"
			then
				secLevel=1
			elif echo $secLevel | grep -i "AuthPriv"
			then
				secLevel=2
			else
				secLevel=""
			fi
		else
			secLevel=0
		fi

		if echo $ip | grep ":" > /dev/null 2>&1
		then
			snmpPort=$( echo $ip | sed -r 's/[^:]:(.*)/\1/' )
		fi

		#Set type of connection for Zabbix
		case $snmpVersion in
			"1")
				zabbixType=$SNMPV1
			;;
			"2c")
				zabbixType=$SNMPV2
			;;
			"3")
				zabbixType=$SNMPV3
			;;
			*)
				echo "SNMP version not defined (-v parameter for snmpwalk)"
				exit
			;;
		esac

		#Get the snmp type of each item
		itemTypes=( $( GetTypes "$snmpItems" ) )
		#Get the oid of each item
		itemOids=( $( GetOids "$snmpItems" ) )

		local i=0
		local h=0
		total=${#itemOids[*]}
		#Loop that add each item and graph to template
		for (( i=0; $i<${#itemOids[*]}; i++ ))
		do
			valueType=-1
			key=$( GetKey "${itemOids[$i]}" )
			graphname=$key

			#Add each item to template
			AddItem "${itemOids[$i]}" "${itemTypes[$i]}"
			if [ $? -eq 1 ]
			then
				echo "ERROR: Unrecognized item type ${itemTypes[$i]} in oid ${itemOids[$i]}, item no added so :("
				exit
			fi
			(( h++ ))
			clear
			printf "Total items: $total\nItems added: $h\n"
			
			#If the item is an integer, generate a graph fo it
			if [ $valueType -eq $INTEGER ] || [ $valueType -eq $FLOAT ]
			then
				#Fill graph item values
				keys[0]=$key
				drawTypes[0]=1
				sortOrders[0]=0
				colors[0]=${defColors[0]}
				yAxysSides[0]=1
				calcFunctions[0]=2
				elementTypes[0]=0
				periodsCounter[0]=5

				#Search for joinable graph items (-jg option)
				if echo ${joinGraphs[*]} | grep -E  "$( echo "${itemOids[$i]}" | sed -r 's/\.[0-9]+$/./')"  > /dev/null 2>&1 && [ ${#itemOids[*]} -gt 1 ]
				then
					#there is joins defined
					for joinThis in ${joinGraphs[*]}
					do
						#Make an array of joined elements for each join defined
						#it can be 2 or more elements
						elements=( $( echo $joinThis | grep "$( echo "${itemOids[$i]}" | sed -r 's/\.[0-9]+$/./')" | sed -r 's/\+/ /g' ) )
						local a=1
						#skip firts element because it's added just above (the 0 index one)
						for (( a=1; $a<${#elements[*]}; a++ ))
						do
							keys[$a]=$key
							drawTypes[$a]=1
							sortOrders[$a]=$a
							if [ -z ${defColors[$a]} ]
							then
								while [ $( echo -n ${colors[$a]} | wc -c ) -lt 6 ]
								do
									defColors[$a]=${colors[$a]}$(( $RANDOM%9+1 ))
								done
							fi
							colors[$a]=${defColors[$a]}
							yAxysSides[$a]=1
							calcFunctions[$a]=2
							elementTypes[$a]=0
							periodsCounter[$a]=5

							#Search the element in the items and remove it to 
							#avoid duplicate items and graphs
							el=$( echo "${itemOids[*]}" | sed -r "s/(.*${elements[$a]}$( GetIndex "${itemOids[$i]}" )).*/\1/" | wc -w )
							(( el-- ))

							AddItem "${itemOids[$el]}" "${itemTypes[$el]}"
							if [ $? -eq 1 ]
							then
								echo "ERROR: Unrecognized item type ${itemTypes[$i]} in oid ${itemOids[$i]}, item no added so :("
								exit
							fi
							(( h++ ))
							clear
							printf "Total items: $total\nItems added: $h\n"

							#Remove item to avoid duplicate it
							unset itemOids[$el]
							unset itemTypes[$el]
							itemOids=( $( echo ${itemOids[*]} ) )
							itemTypes=( $( echo ${itemTypes[*]} ) )
						done
					done
				fi

				#Add a graph item
				AddGraph

				#unset elements
				#unset itemOids[$i]
				#unset itemTypes[$i]
				unset keys[*]
				unset graphname
				unset drawTypes[*]
				unset sortOrders[*]
				unset colors[*]
				unset yAxysSides[*]
				unset calcFunctions[*]
				unset elementTypes[*]
				unset periodsCounter[*]

				#Rebuilds item arrays
				#itemOids=( $( echo ${itemOids[*]} ) )
				#itemTypes=( $( echo ${itemTypes[*]} ) )
			fi
		done

		if [ "$outputModule" == "*" ]
		then
			finalTemplateName="zabbix_$templateName"
		else
			finalTemplateName=$templateName
		fi
printf "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<zabbix_export version=\"1.0\" date=\"05.08.10\" time=\"12.30\">
	<hosts>
		<host name=\"$( basename $finalTemplateName )\">
			<proxy_hostid>0</proxy_hostid>
			<useip>0</useip>
			<dns></dns>
			<ip>0.0.0.0</ip>
			<port>10050</port>
			<status>3</status>
			<useipmi>0</useipmi>
			<groups>
				<group>Templates</group>
			</groups>
			<items>
			$items
			</items>
			<graphs>
			$graphs
			</graphs>
		</host>
	</hosts>
	<dependencies/>
</zabbix_export>" > $finalTemplateName.xml
	fi
}

run
